/*
Version: 1.0
Licencia: GNU
Descripción: Pintar mes de un año concreto
Fecha: 19/12/2022
Autor: Alfonso Javier Gil Llamas
*/

#include <iostream>
#include <cstdlib>

using namespace std;

int bisiesto(int year)
{
    if ((year % 4 == 0) && ((year % 100 != 0) || (year % 400 == 0)))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

// Calcula los días que hay desde el 1/1/1 hasta la fecha enviada y devuelve -1 si la fecha no es válida
int CalcularDias(int dia, int mes, int ano)
{
    int esbisiesto = bisiesto(ano); //
    --ano;
    // hemos calculado dias de años completos
    int TotalDias = (ano * 365) + (ano / 4) - (ano / 100) + (ano / 400);

    // CALCULAR dias de meses completos
    switch (mes)
    {
    case 2:
        // febrero, solo ha pasado enero como mes entero
        TotalDias += 31;
        break;
    case 3: // marzo
        TotalDias += (59 + esbisiesto);
        break;
    case 4: // abril
        TotalDias += (90 + esbisiesto);
        break;
    case 5: // mayo
        TotalDias += (120 + esbisiesto);
        break;
    case 6: // junio
        TotalDias += (151 + esbisiesto);
        break;
    case 7: // julio
        TotalDias += (181 + esbisiesto);
        break;
    case 8: // agosto
        TotalDias += (212 + esbisiesto);
        break;
    case 9: // septiembre
        TotalDias += (243 + esbisiesto);
        break;
    case 10: // octubre
        TotalDias += (273 + esbisiesto);
        break;
    case 11: // Noviembre (10 meses completos)
        TotalDias += (304 + esbisiesto);
        break;
    case 12: // diciembre (11 meses completos)
        TotalDias += (334 + esbisiesto);
        break;
    default:
        break;
    }

    TotalDias += dia;
    return TotalDias;
}

// Devuelve el nombre del mes que le pasamos como parámetro
string NombreMes(int mes)
{
    if (mes < 1 || mes > 12)
    {
        return ("error");
    }
    switch (mes)
    {
    case 1:
        return ("Enero");
    case 2:
        return ("Febrero");
    case 3: // marzo
        return ("Marzo");
    case 4: // abril
        return ("Abril");
    case 5: // mayo
        return ("Mayo");
    case 6: // junio
        return ("Junio");
    case 7: // julio
        return ("Julio");
    case 8: // agosto
        return ("Agosto");
    case 9: // septiembre
        return ("Septiembre");
    case 10: // octubre
        return ("Octubre");
    case 11: // Noviembre (10 meses completos)
        return ("Noviembre");
    case 12: // diciembre (11 meses completos)
        return ("Diciembre");
    }
}

// devuelve el día de la semana 1 lunes martes 2 ... domingo 0;
int DiaSemana(int dia, int mes, int ano)
{
    int TotalDias = CalcularDias(dia, mes, ano);
    TotalDias %= 7;
    if (TotalDias == 0)
    {
        TotalDias = 7;
    }
    return TotalDias;
}

int DiasMes(int mes, int ano)
{
    if (mes == 1 || mes == 3 || mes == 5 || mes == 7 || mes == 8 || mes == 10 || mes == 12){
        return 31;
    }
    else if (mes == 2){
        if(bisiesto(ano) == 1){
            return 29;
        } else {
            return 28;
        }
    } else {
        return 30;
    }
}

int main()
{
    system("clear");
    int mes = 0, ano = 0, diasemana, diasmes;
    while (true)
    {
        cout << "\nMe puede decir el mes: ";
        cin >> mes;
        cout << "\nMe puede decir el año: ";
        cin >> ano;
        if (mes > 0 && mes < 13 && ano > 0)
        {
            break;
        }
        cout << "\nHa introducido dados incorrectos, vuelva a intentarlo";
    }

    cout << "\n\t\t\t" << NombreMes(mes) << " " << ano;
    cout << "\n\tL"
         << "\tM"
         << "\tX"
         << "\tJ"
         << "\tV"
         << "\tS"
         << "\tD\n";

    diasemana = DiaSemana(1, mes, ano);
    diasmes = DiasMes(mes, ano);
    for (int i = 1; i < diasemana; i++)
    {
        cout << "\t ";
    }
    int contador = diasemana;
    for (int dia = 1; dia <= diasmes; dia++)
    {
        cout << "\t" << dia;
        if((contador % 7) == 0){
            cout << "\n";
        }
        contador++;
    }

    cout << "\n\n\n\n";
    return 0;
}
