
#include <iostream>
#include <cstdlib>

using namespace std;

/// @brief Buscar una palabra en un texto
/// @param texto Texto donde buscar
/// @param palabra Palabra a buscar
/// @param indiferente true por defecto no tiene en cuenta mayuscula y minúsculas, false si lo tiene en cuenta
/// @return Primera posición donde lo encuentra... siendo 0 la primero. -1 si no lo encuentra
int BuscarTexto(string texto, string palabra, bool indiferente = true);

/// @brief Calcula el tamaño de una cadena
/// @param texto cadena a evaluar
/// @return cantidad de carácteres de la cadena
int LongitudTexto(string texto);

/// @brief Convierto un texto a minúsculas
/// @param texto Texto a convertir
/// @return La cadena convertida en minúsculas
string aMinuscula(string texto);




int BuscarTexto(string texto, string palabra, bool indiferente){
    if(indiferente){
        texto = aMinuscula(texto);
        palabra = aMinuscula(palabra);
    }

    int textolongitud = LongitudTexto(texto), palabralongitud = LongitudTexto(palabra);
    for (int l = 0; l < textolongitud; l++){
        int contador = 0;
        for (int l2 = 0; l2 < palabralongitud; l2++){
            if(texto[l + l2] == palabra[l2]){
                contador++;
            } else {
                break;
            }
        }
        if(contador == palabralongitud){
            return l;
        }
    }
    return -1;
}

int LongitudTexto(string texto){
    int longitud = 0;
    while (texto[longitud]){
        longitud++;
    }
    return longitud;
}

string aMinuscula(string texto)
{
    for (int l = 0; l < LongitudTexto(texto); l++){
        texto[l] = tolower(texto[l]);
    }
    return texto;
}
