/*
Version: 1.0
Licencia: GNU
Descripción: Creamos un sistema de generación de operaciones aritméticas para niños
Fecha: 2/6/2023
Autor: Alfonso Javier Gil Llamas
*/

#include <iostream>
#include <cstdlib>
#include <time.h>

using namespace std;

int acertadas = 0;

void pintarOperacion(int operacion, int o1, int o2)
{
    char opera[3] = {'+', '-', 'X'};
    cout << "\n  \t\t\t\t\t " << o1;
    cout << "\n\t\t\t\t\t" << opera[operacion] << o2;
    cout << "\n\t\t\t\t\t"
         << "──────";
    cout << "\n  \t\t\t\t\t";
}

int generarOperacion(int nivel, int operacion)
{
    int max[3] = {10, 100, 1000}; // vector o array
    int o1, o2, resultado;
    o1 = rand() % (max[nivel]);
    o2 = rand() % (max[nivel]);

    if (operacion == 0) // sumar
    {
        pintarOperacion(operacion, o1, o2);
        cin >> resultado;
        if (resultado == (o1 + o2))
        {
            cout << "\nMUY BIEN";
            acertadas++;
        }
        else
        {
            cout << "\nHAS FALLADO";
        }
    }
    else if (operacion == 1)
    {
        if (o1 < o2)
        {
            int pivote = o1;
            o1 = o2;
            o2 = pivote;
        }
        pintarOperacion(operacion, o1, o2);
        cin >> resultado;
        if (resultado == (o1 - o2))
        {
            cout << "\nMUY BIEN";
            acertadas++;
        }
        else
        {
            cout << "\nHAS FALLADO";
        }
    }
    else if (operacion == 2)
    {
        pintarOperacion(operacion, o1, o2);
        cin >> resultado;
        if (resultado == (o1 * o2))
        {
            cout << "\nMUY BIEN";
            acertadas++;
        }
        else
        {
            cout << "\nHAS FALLADO";
        }
    }
}

int main()
{
    system("clear");
    srand(time(NULL)); // inicializar el proceso de generación de números aleatorios...

    int operacion, nivel, cantidad;
    cout << "\n";
    cout << "▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓\n";
    cout << "▓ Su operación:                         ▓\n";
    cout << "▓      0 SUMA                           ▓\n";
    cout << "▓      1 RESTA                          ▓\n";
    cout << "▓      2 MULTIPLICACIÓN                 ▓\n";
    cout << "▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓\n";
    cin >> operacion;
    cout << "\n";
    cout << "▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓\n";
    cout << "▓ Nivel                                 ▓\n";
    cout << "▓      0 FACIL                          ▓\n";
    cout << "▓      1 NORMAL                         ▓\n";
    cout << "▓      2 DIFICIL                        ▓\n";
    cout << "▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓\n";
    cin >> nivel;

    cout << "\n";
    cout << "▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓\n";
    cout << "▓ Cantidad de operaciones:              ▓\n";
    cout << "▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓\n";
    cin >> cantidad;

    system("clear");

    if (nivel >= 0 && nivel <= 2 && operacion >= 0 && operacion <= 2)
    {
        for (int i = 1; i <= cantidad; i++)
        {
            generarOperacion(nivel, operacion);
        }
    }
    else
    {
        cout << "\nERROR Debe seleccionar una operación o nivel válido";
        return 0;
    }

    cout << "\n\nRESULTADOS: ";
    cout << "\n\tHas acertado " << acertadas << " de " << cantidad;

    cout << endl;
    cout << endl;
    cout << endl;

    return 0;
}