/*
Version: 1.0
Licencia: GNU

Descripción: Programa que resuleve un sudoku
Fecha: 8/6/2023
Autor: Alfonso Javier Gil Llamas
*/

#include <iostream>
#include <cstdlib>

using namespace std;

void pintar(int sudoku[][9]);
void resolver(int sudoku[][9]);
int buscar(int p, int f, int c, int sudoku[][9]);


int main()
{
    system("clear");
    int sudoku[9][9] =
        {
            {0, 3, 0,  0, 7, 5,  1, 0, 0},
            {4, 5, 6,  0, 0, 2,  0, 0, 7},
            {0, 7, 0,  0, 4, 0,  0, 0, 0},

            {7, 0, 1,  0, 0, 0,  3, 0, 0},
            {0, 4, 2,  5, 3, 0,  7, 0, 1},
            {3, 0, 0,  7, 0, 0,  4, 2, 0},

            {0, 8, 0,  3, 0, 6,  5, 1, 4},
            {5, 0, 4,  0, 1, 0,  0, 0, 0},
            {6, 0, 3,  4, 5, 0,  0, 0, 0},
        };
    pintar(sudoku);
    resolver(sudoku);
    cout << "\n\n";
    pintar(sudoku);

    cout << endl;
    return 0;
}

void resolver(int sudoku[][9]){
    static int resuelto = 0;
    static int vueltas = 1;
    for (int f = 0; f < 9; f++){
        for (int c = 0; c < 9; c++){
            if(sudoku[f][c] == 0){
                for (int p = 1; p <= 9; p++){
                    if(buscar(p, f, c, sudoku) == 1){
                        sudoku[f][c] = p;
                        vueltas++;
                        resolver(sudoku);
                        if (resuelto == 1){
                            return;
                        }
                    }
                }
                sudoku[f][c] = 0;
                return;
            }
        }
    }
    resuelto = 1;
    cout << vueltas << "\n";
    return;
}

int buscar(int p, int f, int c, int sudoku[][9]){
    for (int i = 0; i < 9; i++){
        if(sudoku[f][i] == p || sudoku[i][c] == p){
            return 0;
        }
    }

    int ff = f - (f % 3); 
    int cc = c - (c % 3);

    for (int fff = ff; fff < ff + 3; fff++){
        for (int ccc = cc; ccc < cc + 3; ccc++){
            if(sudoku[fff][ccc] == p){
                return 0;
            }
        }   
    }

    return 1;
}

void pintar(int sudoku[][9]){
    for (int f = 0; f < 9; f++){
        for (int c = 0; c < 9; c++){
            if(c % 3 == 0 && c != 0){
                cout << " ";    
            }
            cout << " " << sudoku[f][c];
            
        }
        if((f+1) % 3 == 0 && f != 0){
            cout << "\n";    
        }    
        cout << "\n";
    }
}