/*
Version: 1.0
Licencia: GNU

Descripción: Reinas Ajedrez
Fecha: 8/6/2023
Autor: Alfonso Javier Gil Llamas
*/

#include <iostream>
#include <cstdlib>

using namespace std;

void resolver(int cantidad, int ajedrez[]);
void marcar(int n, int cantidad, int ajedrez[], int sumar);
void pintar(int cantidad, int ajedrez[]);


int main(){
    system("clear");
    cout << "\nCantidad: ";
    int cantidad;
    cin >> cantidad;
    int total = cantidad * cantidad;
    int ajedrez[total];
    for (int n = 0; n < total; n++){
        ajedrez[n] = 0;
    }
    
    resolver(cantidad, ajedrez);
    
    pintar(cantidad, ajedrez);

    
    cout << "\n\n";
    return 0;
}

void resolver(int cantidad, int ajedrez[]){
    static int reinas = 0;
    int total = cantidad * cantidad;
    for (int n = 0; n < total; n++){
        if(ajedrez[n] == 0){
            reinas++;
            marcar(n, cantidad, ajedrez, 1);
            pintar(cantidad, ajedrez);
            resolver(cantidad, ajedrez);
            if (reinas == cantidad){ // RESUELTO
                return;
            }
            reinas--;
            marcar(n, cantidad, ajedrez, -1);
        }
    }
}

void marcar(int n, int cantidad, int ajedrez[], int sumar){
    int total = cantidad * cantidad;
    //marcamos la fila
    int inicio = n - (n % cantidad); // nos situamos en lo que se supone es la primera posición de la fila 24 - 4 = 20
    for (int i = inicio; i < inicio + cantidad; i++){
        ajedrez[i] += sumar;
    }

    //marcamos la columna
    inicio = n - (cantidad * (n / cantidad)); //// nos situamos en lo que se supone es la primera posición de la columna 12 - (5 * (12/5)) = 2
    for (int i = inicio; i < total; i+=cantidad){
        ajedrez[i] += sumar;
    }  

    //diagonales
    int i = n;
    while(i >= 0){
        ajedrez[i] += sumar;
        if(i == 0 || i % cantidad == 0 || i < cantidad){
            i = -1;
        } else {
            i -= (cantidad + 1);
        }
    }

    i = n;
    while(i < total){
        ajedrez[i] += sumar;
        if((i + 1) % cantidad == 0 || i >= total - cantidad){
            i = total;
        } else {
            i += (cantidad + 1);
        }
        
    }


    //oblicuas
    i = n;
    while(i >= 0){
        ajedrez[i] += sumar;
        if((i + 1) % cantidad == 0 || i < cantidad){
            i = -1;
        } else {
            i -= (cantidad - 1);
        }
        
    }

    i = n;
    while(i < total){
        ajedrez[i] += sumar;
        if(i == 0 || (i % cantidad == 0) || i >= total - cantidad){
            i = total;
        } else {
            i += (cantidad - 1);
        }
    }


    //marcamos o desmarcamos
    if(sumar == 1){
        ajedrez[n] = -1;
    } else {
        ajedrez[n] = 0;
    }

}






void pintar(int cantidad, int ajedrez[]){     
    int total = cantidad * cantidad;
    for (int n = 0; n < total; n++){
        if(ajedrez[n] == -1){
            cout << "♛ ";
        } else {
            cout << ajedrez[n] << " " ;
        }
        
        if((n+1) % cantidad == 0){
            cout  << "\n";
        }
    }
    cout << "\n\n";
}