#include <iostream>
#include <cstdlib>

using namespace std;


bool Bisiesto(int year);
bool FechaValidad(int dia, int mes, int year);
int CalcularDiasFecha(int dia, int mes, int year);
int DiadelaSemana(int dia, int mes, int year);
void DiadelaSemanaTexto(int dia, int mes, int year);



int dispormes[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
string diasdelasemana[7] = { "DOMINGO", "LUNES", "MARTES", "MIÉRCOLES", "JUEVES", "VIERNES", "SÁBADO"};
string meses[12] = {"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};

/// @brief Calcula si un año es bisiesto
/// @param year 
/// @return Verdadero o falso 0 o 1
bool Bisiesto(int year){
    if ((year % 4 == 0) && ((year % 100 != 0) || (year % 400 == 0))){
        return 1;
    }
    else{
        return 0;
    }
}


/// @brief Devuelve si una fecha es correcta
/// @param dia 
/// @param mes 
/// @param year 
/// @return Devuelva verdadero o falso 0 -1 
bool FechaValidad(int dia, int mes, int year){
    if(year > 0){
        if(mes >= 1 && mes <= 12){
            dispormes[1] += Bisiesto(year);
            if(dia >= 1 && dia <= dispormes[mes-1]){
                return true;
            }
        }
    }
    return false;
}


/// @brief Devuelve un entero positivo con la cantidad de días desde el 1/1/1. o -1 si la fecha no es válida
/// @param dia 
/// @param mes 
/// @param year 
/// @return -1 o entero
int CalcularDiasFecha(int dia, int mes, int year){
    if(FechaValidad(dia, mes, year)){
        int totaldias = 0;
        totaldias = (--year) * 365;
        totaldias += (year / 4);
        totaldias -= (year / 100);
        totaldias += (year / 400);
        ++year;
        dispormes[1] += Bisiesto(year);
        for(int m = 0; m < mes -1; m++){
            totaldias += dispormes[m];
        }
        totaldias += dia;
        return totaldias;
    } 
    return -1;  
}


/// @brief Devuelve 0 para el Domingo, 1 lunes, 2 martes... 6 Sabado y -1 si no es una fecha correcta
/// @param dia 
/// @param mes 
/// @param year 
/// @return 
int DiadelaSemana(int dia, int mes, int year){
    if(FechaValidad(dia, mes, year)){
        int total = CalcularDiasFecha(dia, mes, year);
        return total % 7;
    }
    return -1;
}

void DiadelaSemanaTexto(int dia, int mes, int year = 2023){
    if(FechaValidad(dia, mes, year)){
        int total = CalcularDiasFecha(dia, mes, year);
        total %= 7;
        
        cout << diasdelasemana[total];
    }
}

void Cal(int mes, int ano){
    if (FechaValidad(1,mes,ano)){
        int diadelaseman = DiadelaSemana(1,mes,ano);
        cout << "\n\t" << meses[mes - 1];
        cout << "\n  L  M  X  J  V  S  D\n";
        int contadordias = 0;
        if(diadelaseman == 0){
            diadelaseman = 7;
        }
        for(int d = 1; d < diadelaseman; d++){
            cout << "   ";
            contadordias++;
        }
        for (int d = 1; d <= dispormes[mes - 1]; d++){
            if(d < 10){
                cout << " ";
            }
            cout << " " << d;
            contadordias++;
            if(contadordias == 7){
                cout << "\n";
                contadordias = 0;
            }
        }
        
    } else {
        cout << "\nError";
    }
}

void Cal(int ano){
    if (FechaValidad(1,1,ano)){
        for (int mes = 1; mes <= 12; mes++){
            Cal(mes, ano);
        }
    } else {
        cout << "\nError";
    }
}