
#include <iostream>
#include <cstdlib>

using namespace std;

/// @brief Calcula si un año es bisiesto
/// @param year 
/// @return Verdadero o falso 0 o 1
bool Bisiesto(int year);

/// @brief Devuelve si una fecha es correcta
/// @param dia 
/// @param mes 
/// @param year 
/// @return Devuelva verdadero o falso 0 -1 
bool FechaValida(int dia, int mes, int year);

/// @brief Devuelve un entero positivo con la cantidad de días desde el 1/1/1. o -1 si la fecha no es válida
/// @param dia 
/// @param mes 
/// @param year 
/// @return -1 o entero
int CalcularDiasFecha(int dia, int mes, int year);

/// @brief Devuelve 0 para el Domingo, 1 lunes, 2 martes... 6 Sabado y -1 si no es una fecha correcta
/// @param dia 
/// @param mes 
/// @param year 
/// @return 
int DiadelaSemana(int dia, int mes, int year);

void DiadelaSemanaTexto(int dia, int mes, int year);

/// @brief Pintar un mes de un año
/// @param mes int
/// @param year int
void Pintar(int year, int mes = -1);

/// @brief Pinta un año compleo
/// @param year año
//void Pintar(int year);


int diaspormes[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
string diasdelasemana[7] = { "DOMINGO", "LUNES", "MARTES", "MIÉRCOLES", "JUEVES", "VIERNES", "SÁBADO"};
string meses[12] = {"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};




bool Bisiesto(int year){
    if ((year % 4 == 0) && ((year % 100 != 0) || (year % 400 == 0))){
        return 1;
    }
    else{
        return 0;
    }
}

bool FechaValida(int dia, int mes, int year){
    
    if(year > 0){
        if(mes >= 1 && mes <= 12){
            diaspormes[1] += Bisiesto(year);
            if(dia >= 1 && dia <= diaspormes[mes-1]){
                return true;
            }
        }
    }
    return false;
}

int CalcularDiasFecha(int dia, int mes, int year){
    if(FechaValida(dia, mes, year)){
        int totaldias = 0;
        totaldias = (--year) * 365;
        totaldias += (year / 4);
        totaldias -= (year / 100);
        totaldias += (year / 400);
        ++year;
        diaspormes[1] += Bisiesto(year);
        for(int m = 0; m < mes -1; m++){
            totaldias += diaspormes[m];
        }
        totaldias += dia;
        return totaldias;
    } 
    return -1;  
}

int DiadelaSemana(int dia, int mes, int year){
    if(FechaValida(dia, mes, year)){
        int total = CalcularDiasFecha(dia, mes, year);
        return total % 7;
    }

    return -1;
}

void DiadelaSemanaTexto(int dia, int mes, int year = 2023){
    if(FechaValida(dia, mes, year)){
        int total = CalcularDiasFecha(dia, mes, year);
        total %= 7;
        cout << diasdelasemana[total];
    }
}

void Pintar(int year, int mes){
    if(mes == -1){
        for (int m = 1; m <= 12; m++){
            Pintar(year, m);   
        }
        cout << "\nHola ";
    }

    if(FechaValida(1,mes,year)){
        cout << "\n\t" << meses[mes-1] << " " << year << "\n";
        cout << "  L  M  X  J  V  S  D\n";
        int primerdia = DiadelaSemana(1,mes,year);
        if(primerdia == 0){
            primerdia = 7;
        }
        for (int d = 1; d < primerdia; d++){
            cout << "   ";
        }
        primerdia--;
        for (int d = 1; d <= 9; d++){
            primerdia++;
            cout << "  " << d;
            if(primerdia == 7){
                cout << "\n";
                primerdia = 0;
            }
        }
        for (int d = 10; d <= diaspormes[mes-1]; d++){
            primerdia++;
            cout << " " << d;
            if(primerdia == 7){
                cout << "\n";
                primerdia = 0;
            }
        }
    } else {
        cout << "error";
    }
}

/* void Pintar(int year){
    if (year > 0){
        for (int m = 1; m <= 12; m++){
            Pintar(m, year);
            cout << "\n";
        }
    }
} */