#include <iostream>
#include "bus.h"

using namespace std;

class linea
{
private:
    bus *buslinea;
    int *asientos;

public:
    string nombre;
    float precio;

    linea(/* args */)
    {
        this->asientos = NULL;
        this->buslinea = NULL;
    }

    ~linea()
    {
    }

    void asignarBus(bus *b){
        this->buslinea = b;
        this->buslinea->cantidad_asientos = this->buslinea->cantidad_asientos;
        this->asientos = new int[this->buslinea->cantidad_asientos];
        for (int i = 0; i < this->buslinea->cantidad_asientos; i++)
        {
            this->asientos[i] = 1;
        }
    }


    void pintarBus(){
        if(this->buslinea == NULL || this->buslinea->cantidad_asientos == 0){
            cout << "\nERROR... esta línea no tiene ningún bus asignado";
            return;
        }
        for (int a = 0; a < 4; a++)
        {
            for (int i = a; i < this->buslinea->cantidad_asientos; i+=4)
            {
                if(this->asientos[i] == 1){
                    cout << i << "\t";
                } else {
                    cout << "XX\t";
                }
            }    
            cout << "\n";
        }
    }

    void venderAsiento(int asiento){
        if(this->buslinea == NULL || this->buslinea->cantidad_asientos == 0){
            cout << "\nERROR... esta línea no tiene ningún bus asignado";
            return;
        }
        if(this->asientos[asiento] == 1){
            this->asientos[asiento] = 0;
        } else {
            cout << "\nERROR... asiento ocupado\n";
        }
    }

};
