<?php
$meses = ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
function esBisiesto($year)
{
    if (($year % 4 == 0) && (($year % 100 != 0) || ($year % 400 == 0))) {
        return 1;
    } else {
        return 0;
    }
}


function diaSemana($dia, $mes, $year)
{
    $totaldias = 0;
    $diaspormes = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    $totaldias = (--$year) * 365;
    for ($a = 1; $a <= $year; $a++) {
        $totaldias += esBisiesto($a);
    }
    ++$year;
    $diaspormes[1] += esBisiesto($year);
    for ($m = 0; $m < $mes - 1; $m++) {
        $totaldias += $diaspormes[$m];
    }
    $totaldias += $dia;
    return $totaldias % 7;
}

function PintarMes($mes, $year)
{
    $meses = ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
    $diaspormes = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    $diaspormes[1] += esBisiesto($year);
    echo '
        <div>
        <table>
            <caption>' . $meses[$mes - 1] . '</caption>
            <thead>
                <tr>
                    <th>L</th>
                    <th>M</th>
                    <th>X</th>
                    <th>J</th>
                    <th>V</th>
                    <th>S</th>
                    <th>D</th>
                </tr>
            </thead>
            <tbody>
            <tr>
        ';
    $diames = 1;
    $diadelasemana = diaSemana(1, $mes, $year);
    if ($diadelasemana == 0) {
        $diadelasemana = 7;
    }

    for ($v = 1; $v < $diadelasemana; $v++) {
        echo "<td></td>";
    }
    $diadelasemana--;

    for ($d = 1; $d <= $diaspormes[$mes - 1]; $d++) {
        $nombreFichero = $d . "_" . $mes . "_" . $year . ".txt";
        $clase = "";
        $title = "";
        if(file_exists("eventos/" . $nombreFichero)){
            $clase = " class='diaconeventos' ";
            $eventos = "";
            $eventos = file_get_contents("eventos/" . $nombreFichero);
            if($eventos != ""){
                $eventos = unserialize($eventos);
                $title = "title='";
                foreach ($eventos as $e => $value) {
                    $title .= $eventos[$e][0] . " " . $eventos[$e][1] . "\n\n";  
                }
                $title .= "'";
            }
        }
        if ($diadelasemana < 7) {
            echo "<td " . $clase . "><a " . $title . " href='eventos.php?dia=" . $d . "&mes=" . $mes . "&year=" . $year . "'>" . $d . "</a></td>";
        } else {
            echo "</tr><tr><td " . $clase . "><a " . $title . " href='eventos.php?dia=" . $d . "&mes=" . $mes . "&year=" . $year . "'>" . $d . "</a></td>";
            $diadelasemana = 0;
        }
        $diadelasemana++;
    }

    for ($v = $diadelasemana; $v < 7; $v++) {
        echo "<td></td>";
    }

    echo '</tr></tbody></table></div>';
}
