<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="#3d2505" />

    <meta name="description" content="App para gestionar la cesta de la compra" />
    <meta name="keywords" content="app,cesta,compra" />
    <meta http-equiv="content-language" content="es-ES">


    <title>La cesta de la compra</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
    <script>
        if ("serviceWorker" in navigator) {
            navigator.serviceWorker.register("sw.js");
        }


        const elNavegadorEsCompatible = () => {
            if (navigator.userAgent.indexOf("Chrome") ||
                navigator.userAgent.indexOf("Edge") ||
                navigator.userAgent.indexOf("Safari")) return true;
            alert('El Navegador no es compatible con el Reconocimiento de voz');
            return false;
        }


        function escuchar() {
            if (elNavegadorEsCompatible()) {

                const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition || window.mozSpeechRecognition || window.msSpeechRecognition;
                recognition = new SpeechRecognition();
                recognition.continuous = true;
                recognition.start();
                recognition.onresult = function(event) {
                    var transcript = event.results[0][0].transcript;
                    $("#producto").val("");
                    $("#producto").val(transcript);
                    $("#guardar").click();
                    //$("#guardar").keyup();
                    recognition.stop();
                };
            }
        }
    </script>
    <link rel="manifest" href="manifest.webmanifest">

</head>

<body>
    <header>
        <form action="index.php" method="post">
            <?php
            $comercios = ["Mercadona", "Día", "Corte Inglés", "Consum", "Carrefour", "Tienda Paco"];
            ?>
            <select name="comercio" required>
                <option value="">Comercios...</option>
                <option value="0" selected>Indiferente</option>
                <?php
                foreach ($comercios as $key => $value) {
                    echo '<option value="' . $key . '">' . $value . '</option>';
                }
                ?>
            </select>
            <input type="text" id="producto" name="producto" required placeholder="Nuevo Producto">
            <i onclick="escuchar();" class="fa-solid fa-microphone"></i>
            <button class="boton_sin" id="guardar" type="submit"><i class="fa-solid fa-floppy-disk"></i></button>
        </form>
    </header>

    <?php
    $productos = [];
    $productos = unserialize(file_get_contents("productos.txt"));
    if (isset($_POST['producto']) && $_POST['producto'] != "") {
        $productos[] = [$_POST['comercio'], $_POST['producto']];
        array_multisort(array_column($productos, 0), SORT_ASC, $productos, array_column($productos, 1), SORT_NATURAL, $productos);
        file_put_contents("productos.txt", serialize($productos));
    }
    ?>
    <main>
        
            <?php
            $comercio = -1;
            if (count($productos) > 0) {
                foreach ($comercios as $k => $v) {
                    echo "<h3>" . $v . "</h3><ul>";
                    foreach ($productos as $key => $value) {
                        if ($value[0] == $k) {
                            echo '
                                <li>
                                    <div>' . $value[1] . '</div>
                                    <div class="derecha"><a href="borrar.php?id=' . $key . '" <i class="fa-solid fa-basket-shopping"></i></a></div>
                                </li>
                            ';
                        }
                    }
                    echo "</ul>";
                }
            } else {
                echo "<h3>Sin productos en la lista...</h3>";
            }
            ?>
        
    </main>



</body>

</html>