<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pedidos</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="css.css">
</head>

<body>
    <?php
    include_once("productos.php");
    ?>

    <header>
        <nav>
            <a href="index.php"><i class="fa-solid fa-house"></i></a>
            <?php
            $cesta = [];
            if (isset($_COOKIE['cesta'])) {
                $cesta = unserialize(base64_decode($_COOKIE['cesta']));
                echo '<a href="cesta.php"><i class="fa-solid fa-cart-shopping"></i></a>';
            }
            ?>

        </nav>
    </header>
    <main>
        <?php
        if (count($cesta) > 0) {
        ?>
            <div id="cesta">
                <h1>Cesta</h1>
                <ul>
                    <?php
                    $total = 0;
                    foreach ($cesta as $key => $value) {
                        $total += ($productos[$key][3] * $value);
                    ?>
                        <li>
                            <div><?php echo $productos[$key][0]; ?></div>
                            <div>
                                <form action="editar.php" method="post">
                                    <input type="hidden" name="producto" value="<?php echo $key ?>">
                                    <input type="number" name="cantidad" required value="<?php echo $value; ?>" min="0" max="100">
                                    <button type="submit"><i class="fa-solid fa-pencil"></i></button>
                                </form>
                            </div>
                        </li>
                    <?php
                    }
                    ?>
                    <li>
                        <div>Total:</div>
                        <div><?php echo $total; ?></div>
                    </li>
                    <li>
                        <div>Iva:</div>
                        <div><?php echo $total * 21 / 100; ?></div>
                    </li>
                    <li>
                        <div>TOTAL:</div>
                        <div><?php echo $total + ($total * 21 / 100); ?></div>
                    </li>
                </ul>
            </div>
        <?php
        } else {
            echo "<h1>De momento no tienen nada en la cesta</h1>";
        }
        ?>

    </main>


</body>

</html>