<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pedidos</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="css.css">
</head>

<body>
    <?php
    include_once("productos.php");
    ?>

    <header>
        <nav>
            <a href="index.php"><i class="fa-solid fa-house"></i></a>
            <?php
            $cesta = [];
            if (isset($_COOKIE['cesta'])) {
                $cesta = unserialize(base64_decode($_COOKIE['cesta']));
                echo '<a href="cesta.php"><i class="fa-solid fa-cart-shopping"></i></a>';
            }
            ?>
            
        </nav>
    </header>
    <main>

        <ul>
            <?php
            foreach ($productos as $key => $value) {
            ?>
                <li>
                    <h2><?php echo $value[0]; ?></h2>
                    <img src="<?php echo $value[2]; ?>" alt="">
                    <p><?php echo $value[1]; ?></p>
                    <div>
                        <div class="precio"><?php echo $value[3]; ?>€</div>
                        <div>
                            <form action="add.php" method="post">
                                <input type="hidden" name="producto" value="<?php echo $key; ?>">
                                <select name="cantidad" required>
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                    <option value="6">6</option>
                                    <option value="7">7</option>
                                    <option value="8">8</option>
                                </select>
                                <input type="submit" value="+">
                            </form>
                        </div>
                    </div>
                </li>
            <?php
            }
            ?>
        </ul>

    </main>


</body>

</html>