<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ejercicios Matemáticos</title>
    <link rel="stylesheet" href="css.css">
</head>

<body>

    <header>
        <form action="index.php" method="post">
            <select name="tipo" required>
                <option value="">Tipo de Operación</option>
                <option value="0">Suma</option>
                <option value="1">Resta</option>
                <option value="2">Multiplicación</option>
                <option value="3">División</option>
                <option value="4">Mezcladas</option>
            </select>
            <select name="dificil" required>
                <option value="">Nivel</option>
                <option value="10">Facil</option>
                <option value="100">Normal</option>
                <option value="1000">Difícil</option>
            </select>
            <input type="number" name="cantidad" required min="1" max="100" placeholder="Cantidad">
            <input type="submit" value="Enviar">
        </form>

    </header>

    <main>

        <?php
        if (isset($_POST['tipo']) && $_POST['tipo'] >= 0) {
            $operacion = $_POST['tipo'];
        ?>
            <form action="index.php" method="post">
                <input type="hidden" name="cantidad" value="<?php echo $_POST['cantidad']; ?>">
                <section>
                    <?php
                    $operaciones = ['+', '-', 'X', '/'];
                    $hasta = $_POST['dificil'];
                    for ($i = 0; $i < $_POST['cantidad']; $i++) {
                        $operacion = $_POST['tipo'];
                        if ($operacion == 4) {
                            $operacion = rand(0, 3);
                        }
                        $desde = 0;
                        $o1 = rand($desde, $_POST['dificil']);
                        if ($operacion == 3) {
                            $desde = 1;
                            $o1 = rand($_POST['dificil'] + $desde, $_POST['dificil'] * 10);
                            $hasta = $_POST['dificil'];
                        }
                        if ($operacion == 1 || $operacion == 2) {
                            $hasta = $o1;
                        }
                        $o2 = rand(0 + $desde, $hasta);

                    ?>
                        <div>
                            <?php
                            echo '<input type="hidden" name="operacion[]" value="' . $operacion . '">';
                            if ($operacion != 3) {
                                echo '<p>' . $o1 . '</p>';
                                echo '<p>' . $operaciones[$operacion] . ' ' . $o2 . '</p>';
                            } else {
                                echo '<p>' . $o1 . ' / ' . $o2 . '</p>';
                            }
                            ?>

                            <input type="hidden" name="o1[]" value="<?php echo $o1; ?>">
                            <input type="hidden" name="o2[]" value="<?php echo $o2; ?>">
                            <hr>
                            <?php
                            if ($operacion == 3) {
                                echo '<input  placeholder="R" type="number" name="resto['.$i.']">';
                            }
                            ?>
                            <input type="number" name="resultado[]">
                        </div>
                    <?php
                    }
                    ?>
                </section>
                <input type="submit" value="Resolver" class="botones">
            </form>
        <?php
        }
        ?>






        <?php
        if (isset($_POST['operacion']) && count($_POST['operacion']) >= 0) {
        ?>

            <section>
                <?php
                $operaciones = ['+', '-', 'X', '/'];
                for ($i = 0; $i < $_POST['cantidad']; $i++) {
                    $o1 = $_POST['o1'][$i];
                    $o2 = $_POST['o2'][$i];
                    $operacion = $_POST['operacion'][$i];
                    $clase = 'ok';
                    switch ($operacion) {
                        case 0:
                            if (($o1 + $o2) != $_POST['resultado'][$i]) {
                                $clase = 'ko';
                            }
                            break;
                        case 1:
                            if (($o1 - $o2) != $_POST['resultado'][$i]) {
                                $clase = 'ko';
                            }
                            break;
                        case 2:
                            if (($o1 * $o2) != $_POST['resultado'][$i]) {
                                $clase = 'ko';
                            }
                            break;
                        case 3:
                            $resto = $o1 % $o2;
                            if (($resto != $_POST['resto'][$i]) || (($o1 - $resto) / $o2 != $_POST['resultado'][$i])) {
                                $clase = 'ko';
                            }
                            break;

                        default:
                            # code...
                            break;
                    }
                ?>
                    <?php
                    if ($operacion != 3) {
                    ?>
                        <div class="<?php echo $clase; ?>">
                            <p><?php echo $o1; ?></p>
                            <p><?php echo $operaciones[$operacion]; ?> <?php echo $o2; ?></p>
                            <hr>
                            <p><?php echo $_POST['resultado'][$i]; ?></p>
                        </div>
                    <?php } else { ?>
                        <div class="<?php echo $clase; ?>">
                            <p><?php echo $o1; ?> <?php echo $operaciones[$operacion]; ?> <?php echo $o2; ?></p>
                            <hr>
                            <p>R: <?php echo $_POST['resto'][$i]; ?>  &nbsp;&nbsp;&nbsp;&nbsp; C: <?php echo $_POST['resultado'][$i]; ?></p>
                        </div>
                    <?php } ?>
                <?php
                }
                ?>

            <?php
        }
            ?>



    </main>

</body>

</html>